/*
 * Created on 02-Jan-2006
 *
 * $Id: IncorrectFormat6010Factory.java,v 1.8 2006/08/10 15:19:11 dec Exp $
 */
package paye.eoy.output.mapper.generic;

import processingError.ProcessingError;
import xmldoc.DocumentError;
import ericResponse.output.error.ERErrorDetail;

public class IncorrectFormat6010Mapper extends AbstractGenericErrorDetailMapper {

    public boolean isApplicable(final ProcessingError pe) {
        return pe.getSubCode().equals(DocumentError.UNKNOWN) || pe.getSubCode().equals(DocumentError.INVALID)
                || pe.getSubCode().equals(DocumentError.ATTRIBUTE);
    }

    public ERErrorDetail mapProcessingError(final ProcessingError pe) {
        final ERErrorDetail detail = new ERErrorDetail();
        detail
                .setMessageText("Your submission is not in the correct format - please contact your software supplier and quote Error Code 6010.");
        detail.setLocator(getLocationString(pe));
        detail.setCode("6010");
        return detail;
    }
}
