/*
 * Created on 02-Jan-2006
 *
 * $Id: InvalidCharacters5012Factory.java,v 1.11 2006/08/10 15:19:11 dec Exp $
 */
package paye.eoy.output.mapper.generic;

import processingError.ProcessingError;
import xmldoc.DocumentError;
import ericResponse.output.error.ERErrorDetail;

public class InvalidCharacters5012Mapper extends AbstractGenericErrorDetailMapper {

    public boolean isApplicable(final ProcessingError pe) {

        boolean result = false;

        result = pe.getSubCode().equals(DocumentError.FORMAT) || pe.getSubCode().equals(DocumentError.MAXVALUE)
                || pe.getSubCode().equals(DocumentError.MINVALUE) || pe.getSubCode().equals(DocumentError.VALUE)
                || pe.getSubCode().equals(DocumentError.LENGTH);

        return result;
    }

    public ERErrorDetail mapProcessingError(final ProcessingError pe) {
        final ERErrorDetail detail = new ERErrorDetail();
        detail.setMessageText("This field contains an invalid character. "
                + "Please try again and if the problem recurs contact your software supplier.");
        detail.setLocator(getLocationString(pe));
        detail.setCode("5012");
        return detail;
    }
}
