package paye.eoy.output.mapper.header;

import paye.eoy.bizrules.header.EmployersReferenceRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * 
 * @author Jay Mistry
 * 
 */
public class EmployersReferenceMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { EmployersReferenceRule.STARTS_WITH_SPACE, "7600", "BR6.2" },
                { EmployersReferenceRule.TOO_LONG, "7600", "BR6.1" },
                { EmployersReferenceRule.MANDATORY, "6010", "generic.6010" },
                { DocumentError.FORMAT, "5012", "generic.5012" }

        };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "IR Office Reference";
    }

    public String[] getRuleNames() {
        return new String[] { "EmployersReferenceRule" };
    }

}
