/**
 * 
 */
package paye.eoy.output.mapper.header;

import hmrc.validator.rules.IREnvelopeRule;
import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import ericResponse.output.translator.TranslationContext;

/**
 * @author Jay Mistry
 * 
 */
public class IREnvelopeMapper extends AbstractPAYEErrorMapper {

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return null;
    }

    @Override
    protected TaxYear getTaxYearFromTranslationContext(final TranslationContext context) {
        return TaxYear.UNKNOWN;
    }

    @Override
    protected SubmissionChannel getSubmissionChannelFromTranslationContext(final TranslationContext context) {
        return SubmissionChannel.UNKNOWN;
    }

    @Override
    public boolean isActive(final TranslationContext context) {
        return true;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { IREnvelopeRule.NO_IR_ENVELOPE, "6010", "IREnvelope" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "IRenvelope";
    }

    public String[] getRuleNames() {
        return new String[] { "IREnvelopeRule" };
    }

}
