package paye.eoy.output.mapper.header;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class IROfficeNumberMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "IROfficeNumberRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.FORMAT, "7595", "BR5.1" },
            { DocumentError.VALUE, "7595", "BR5.1" }, { DocumentError.MANDATORY, "6010", "generic.6010" }, };

    private static final String LOCATOR = "IR Office Number";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
