package paye.eoy.output.mapper.header;

import paye.eoy.bizrules.PeriodEndRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import xmldoc.DocumentError;
import ericResponse.output.translator.TranslationContext;

/**
 * 
 * @author Jay Mistry
 * 
 */
public class PeriodEndMapper extends AbstractPAYEErrorMapper {

    @Override
    public boolean isActive(final TranslationContext context) {
        return true;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return null;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "BR7.1" }, { PeriodEndRule.INVALID_PERIOD_END, "7515", "BR7.2" },
                { DocumentError.BLANK, "5016", "BR7.1A" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Period End";
    }

    public String[] getRuleNames() {
        return new String[] { "PeriodEndRule" };
    }

}
