package paye.eoy.output.mapper.header;

import paye.eoy.bizrules.ReturnTypeCrossCheckRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class ReturnTypeErrorMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "ReturnTypeCrossCheckRule",
            "/IRenvelope/EndOfYearReturn/ReturnType" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { ReturnTypeCrossCheckRule.AMENDED_CONTAINS_ORIGINAL_PART, "6010", "BR1.0" },
            { ReturnTypeCrossCheckRule.ORIGINAL_CONTAINS_AMENDED_PART, "6010", "BR1.0" },
            { DocumentError.VALUE, "5012", "BR1.1" }, { DocumentError.FORMAT, "5012", "BR1.1" }, };

    private static final String LOCATOR = "Return Type";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
