/**
 * 
 */
package paye.eoy.output.mapper.header;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class SenderMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.VALUE, "5012", "generic.5012" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Sender";
    }

    public String[] getRuleNames() {
        return new String[] { "/IRenvelope/IRheader/Sender" };
    }

}
