package paye.eoy.output.mapper.header;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.header.SubmissionTypeRuleOriginal;
import paye.eoy.bizrules.p14.CheckNoP35InP14PartSubmissionRule;
import paye.eoy.bizrules.p14.parttotals.SubtotalsRequiredRule;
import paye.eoy.bizrules.p35.CheckNoP14InP35PartSubmissionRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.Collections;
import java.util.Map;

public class SubmissionTypeMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "SubmissionTypeRule",
            "CheckNoP14InP35PartSubmissionRule", "CheckNoP35InP14PartSubmissionRule",
            "/IRenvelope/EndOfYearReturn/SubmissionType" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { SubmissionTypeRuleOriginal.P35_DEDUCTIONS_LTE_ZERO, "7500", "BR2.2" },
            { SubmissionTypeRuleOriginal.NO_P14, "7500", "BR2.2" },
            { SubmissionTypeRuleOriginal.NO_P35, "7500", "BR2.3" },
            { SubtotalsRequiredRule.HAS_PART_TOTALS, "6010", "BR2.4A" }, { DocumentError.VALUE, "5012", "BR2.1" },
            { DocumentError.FORMAT, "5012", "BR2.1" }, { CheckNoP14InP35PartSubmissionRule._1, "7501", "BR2.4" },
            { CheckNoP35InP14PartSubmissionRule._1, "7502", "BR2.5" } };

    private static final String LOCATOR = "Submission Type";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        return Collections.emptyMap();
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
