package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.p14.AbstractP14CountCountCheck;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import xmldoc.DocumentError;
import ericResponse.output.error.EricResponseErrors;

public abstract class AbstractP14PartTotalsCountCheckMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "P14PartTotalCountCheckRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { AbstractP14CountCountCheck.BAD_COUNT, "7300", "BR48.2" },
            { DocumentError.MINVALUE, "7300", "BR48.3" }, { DocumentError.FORMAT, "5012", "BR48.1" },
            { DocumentError.MANDATORY, EricResponseErrors.DO_NOT_MAP }, { DocumentError.BLANK, "5016", "generic.5016" },
            { AbstractP14CountCountCheck.MISSING, "6010", "generic.6010" } };

    private static final String LOCATOR = "Total number of P14s submitted";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
