/**
 * 
 */
package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.payandtax.TaxInThisEmpRuleOriginal;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;

/**
 * @author Jay Mistry
 * 
 */
public abstract class AbstractP14TaxDeductedinThisEmploymentMapper extends AbstractPAYEErrorMapper {

    private static Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    /**
     * Tolerances are the same for all years.
     */
    static {
        PAPER_TOLERANCES.put(TaxInThisEmpRuleOriginal.GT_PAY_THIS_EMP, Tolerance.DNA);
        PAPER_TOLERANCES.put(TaxInThisEmpRuleOriginal.MUST_BE_LT_TAX_PREV_EMP, Tolerance.DNA);
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Tax deducted in this employment";
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

}
