package paye.eoy.output.mapper.p14;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class DateOfStartingMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] {
            "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Start",
            "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/Start" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.FORMAT, "5012",
            "generic.date.5012" } };

    private static final String LOCATOR = "P14 Date of starting";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
