package paye.eoy.output.mapper.p14;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.bizrules.p14.br0405.atLEL.AbstractEarningsAtLELAggregationRule;
import paye.eoy.bizrules.p14.br0405.atLEL.AbstractEarningsAtLELRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class EarningsAtLELMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "EarningsAtLELRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { AbstractEarningsAtLELRule.MUST_BE_ZERO_FOR_TABLE_CODE, "7130", "BR26.4" },
            { AbstractEarningsAtLELAggregationRule.MUST_BE_GREATER_THAN_ZERO_FOR_CODE, "7130", "BR26.5" },
            { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { WholePoundsHelper.NOT_WHOLE_POUNDS, "5012", "whole.nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR26.2" },
            { DocumentError.MAXVALUE, "5012", "BR26.maxvalue" }, { DocumentError.MANDATORY, "6010", "generic.6010" },
            { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final String LOCATOR = "P14 Earnings at the Lower Earnings Limit (LEL) where earnings reach or exceed the LEL";

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(AbstractEarningsAtLELRule.MUST_BE_ZERO_FOR_TABLE_CODE, Tolerance.DNA);
        PAPER_TOLERANCES.put(AbstractEarningsAtLELAggregationRule.MUST_BE_GREATER_THAN_ZERO_FOR_CODE, Tolerance.DNA);
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }
}
