package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.bizrules.p14.aggregation.EarningsLELtoPTRuleAggregation;
import paye.eoy.bizrules.p14.nic.EarningsLELtoPTRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class EarningsLELtoPTMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "EarningsLELtoPTRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { EarningsLELtoPTRule.MUST_BE_ZERO_FOR_NI_CATEGORY, "7140", "BR27.4" },
            { EarningsLELtoPTRuleAggregation.PT_TO_UAP_ZERO, "7140", "BR27.5" }, { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { WholePoundsHelper.NOT_WHOLE_POUNDS, "5012", "whole.nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR27.2" },
            { DocumentError.MAXVALUE, "5012", "BR27" } };

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(EarningsLELtoPTRuleAggregation.PT_TO_UAP_ZERO, Tolerance.DNA);
        PAPER_TOLERANCES.put(EarningsLELtoPTRule.MUST_BE_ZERO_FOR_NI_CATEGORY, Tolerance.DNA);
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    private static final String LOCATOR = "P14 Earnings above the LEL up to and including the primary threshold (PT)";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return super.getTolerances(year, channel);
        }
    }
}
