package paye.eoy.output.mapper.p14;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.bizrules.p14.br1112.EarningsPTtoUAPRule;
import paye.eoy.bizrules.p14.br1213.EarningsPTtoUAPRuleAggregation;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * @author doug
 * 
 */
public class EarningsPTtoUAPMapper extends AbstractPAYEErrorMapper {

    private static final String LOCATOR = "P14 Earnings above the PT up to and including the Upper Accrual Point (UAP)";

    private static final String[] RULE_NAMES = new String[] { EarningsPTtoUAPRule.EARNINGS_PT_TO_UAP_RULE };

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { EarningsPTtoUAPRule.MUST_BE_ZERO_FOR_NI_CATEGORY, "7150", "BR28.4" },
            { EarningsPTtoUAPRuleAggregation.MUST_BE_GT_ZERO_IF_PT_TO_UAP, "7150", "BR28.1.6" },
            { EarningsPTtoUAPRuleAggregation.ECP16, "7150", "BR28.1.5" },
            { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { WholePoundsHelper.NOT_WHOLE_POUNDS, "5012", "whole.nonneg.amount" },
            { DocumentError.MINVALUE, "5012", "BR28.1.2" },
            { DocumentError.MAXVALUE, "5012", "BR28.maxvalue" } };

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(EarningsPTtoUAPRule.MUST_BE_ZERO_FOR_NI_CATEGORY, Tolerance.DNA);
        PAPER_TOLERANCES.put(EarningsPTtoUAPRuleAggregation.MUST_BE_GT_ZERO_IF_PT_TO_UAP, Tolerance.DNA);
        PAPER_TOLERANCES.put(EarningsPTtoUAPRuleAggregation.ECP16, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

}
