package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.bizrules.p14.EarningsUAPtoUELRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EarningsUAPtoUELMapper extends AbstractPAYEErrorMapper {

    private static final String[][] ERROR_MAP_DATA = new String[][]{{DocumentError.FORMAT, "5012", "nonneg.amount"},
            {WholePoundsHelper.NOT_WHOLE_POUNDS, "5012", "whole.nonneg.amount"}, {DocumentError.MINVALUE, "5012", "BR28.2.2"},
            {DocumentError.MAXVALUE, "5012", "BR28.maxvalue"},
            {EarningsUAPtoUELRule.MUST_BE_ZERO_FOR_NI_CATEGORY, "7155", "BR28b.4"}};

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }


    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(EarningsUAPtoUELRule.MUST_BE_ZERO_FOR_NI_CATEGORY, Tolerance.DNA);
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Earnings above the UAP up to and including the Upper Earnings Limit (UEL)";
    }

    public String[] getRuleNames() {
        return new String[]{"EarningsUAPtoUELRule"};
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }
}
