package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.consolidated.ECONAllowedRule;
import paye.eoy.bizrules.consolidated.ECONRequiredRule;
import paye.eoy.bizrules.p35.ECONFormatRule;
import paye.eoy.bizrules.p35.br0809.AbstractECONRequiredRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Jay Mistry
 */
public class EconMapper extends AbstractPAYEErrorMapper {

    private static Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        TOLERANCES.put(ECONFormatRule.PREFIX, Tolerance.DNA);
        TOLERANCES.put(ECONFormatRule.CHAR_9_MUST_BE_LETTER, Tolerance.DNA);
        TOLERANCES.put(ECONFormatRule.CHAR_2_TO_8_FORMAT, Tolerance.DNA);
        TOLERANCES.put(ECONFormatRule.MOD19, Tolerance.DNA);
        /*
         * Normally all FORMAT errors are caught by the rule and suppressed, as
         * the rule itself carries out all the formatting checks. However,
         * schema errors can be raised in a consolidated submission. Because the
         * ECONFormatRule is not active in consolidation checking, these errors
         * won't be suppressed and will end up coming through here. To cater for
         * that I'm just mapping them all to DNA
         */
        TOLERANCES.put(DocumentError.FORMAT, Tolerance.DNA);

        TOLERANCES.put(AbstractECONRequiredRule.REQUIRED, Tolerance.DNA);
        TOLERANCES.put(ECONRequiredRule.ECON_REQUIRED, Tolerance.DNA);

        // Rule applied to consolidated returns
        PAPER_TOLERANCES.put(ECONAllowedRule.ECON_NOT_ALLOWED, Tolerance.DNA);
        PAPER_TOLERANCES.put(ECONFormatRule.MOD19, Tolerance.DNA);
        PAPER_TOLERANCES.put(AbstractECONRequiredRule.REQUIRED, Tolerance.DNA);
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][]{{ECONFormatRule.PREFIX, "5012", "BR13.format"},
                {ECONFormatRule.LENGTH, "5012", "generic.5012"}, {ECONFormatRule.CHAR_9_MUST_BE_LETTER, "5012", "BR13.format"},
                {ECONFormatRule.CHAR_2_TO_8_FORMAT, "5012", "BR13.format"},
                {AbstractECONRequiredRule.REQUIRED, "7100", "BR13.required"}, {ECONFormatRule.MOD19, "7100", "BR13.invalid"},
                {ECONAllowedRule.ECON_NOT_ALLOWED, "7100", "BR13.notrequired"}, {DocumentError.FORMAT, "5012", "BR13.format"}};
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    @Override
    protected String getLocator(final String subCode) {
        return "ECON";
    }

    public String[] getRuleNames() {
        return new String[]{"ECONRule", "ECONAllowedRule", "ECONRequiredRule",
                "/IRenvelope/EndOfYearReturn/P35/EmployerDetails/ECON",
                "/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/ECON"};
    }

}
