package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class EmployeeAddressMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "EmployeeAddressLineRule",
            "/IRenvelope/EndOfYearReturn/P14/Address/Line", "/IRenvelope/EndOfYearReturn/P14Amended/Address/Line" };

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.FORMAT, "5012", "generic.5012" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.LENGTH, "5012", "generic.5012" } };

    private static Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    /**
     * Tolerances are the same for allActive years.
     */
    static {
        TOLERANCES.put(DocumentError.MANDATORY, Tolerance.DNA);

        PAPER_TOLERANCES.put(DocumentError.MANDATORY, Tolerance.DNA);
    }

    private static final String LOCATOR = "Employee Address";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
