package paye.eoy.output.mapper.p14;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.nic.AbstractEmployeesContributionsPayableRuleOriginal;
import paye.eoy.bizrules.p14.nic.EmployeesContributionsPayableRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class EmployeeContributionsPayableMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "EmployeesContributionsPayableRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { EmployeesContributionsPayableRule.MUST_BE_ZERO_FOR_TABLE_CODE, "7430", "BR30.3" },
            { AbstractEmployeesContributionsPayableRuleOriginal.BOTH, "7430", "BR34.4" },
            { DocumentError.FORMAT, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR30.2" },
            { DocumentError.MAXVALUE, "5012", "nonneg.amount" }, { DocumentError.MANDATORY, "6010", "generic.6010" },
            { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final String LOCATOR = "P14 Employee's contributions payable";

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();
    static {
        PAPER_TOLERANCES.put(EmployeesContributionsPayableRule.MUST_BE_ZERO_FOR_TABLE_CODE, Tolerance.DNA);
        PAPER_TOLERANCES.put(AbstractEmployeesContributionsPayableRuleOriginal.BOTH, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
