package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.EmployeeDOBRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * 
 * @author Jay Mistry
 * 
 */
public class EmployeeDOBMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static final Map<String, Tolerance> TOLERANCES_0405_0607 = new HashMap<String, Tolerance>();

    private static final Map<String, Tolerance> TOLERANCES_0506_0711 = new HashMap<String, Tolerance>();

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(EmployeeDOBRule.REQUIRED, Tolerance.DNA);
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { EmployeeDOBRule.REQUIRED, "7520", "BR15.1" },
                { DocumentError.FORMAT, "5012", "BR15.2" }, { DocumentError.BLANK, "5016", "generic.5016" },
                { EmployeeDOBRule.TOO_LATE, "7520", "BR15.3" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Employee's date of birth";
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else if (year == TaxYear.TAX_YEAR_0405 || year == TaxYear.TAX_YEAR_0607) {
            return TOLERANCES_0405_0607;
        } else {
            return TOLERANCES_0506_0711;
        }
    }

    public String[] getRuleNames() {
        return new String[] { "EmployeeDOBRule" };
    }

}
