/**
 * 
 */
package paye.eoy.output.mapper.p14;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.EmployeeForenameRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;

/**
 * @author Jay Mistry
 * 
 */
public class EmployeeForenameMapper extends AbstractPAYEErrorMapper {

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    /**
     * Tolerances are the same for all years.
     */
    static {
        PAPER_TOLERANCES.put(EmployeeForenameRule.MANDATORY, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { EmployeeForenameRule.FORMAT, "5012", "generic.5012" },
                { EmployeeForenameRule.BLANK, "5016", "generic.5016" },
                { EmployeeForenameRule.MANDATORY, "6010", "generic.6010" },
                { EmployeeForenameRule.FORMAT2, "5012", "generic.5012" },
                { EmployeeForenameRule.BLANK2, "5016", "generic.5016" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Forename";
    }

    public String[] getRuleNames() {
        return new String[] { "EmployeeForenameRule" };
    }

}
