/**
 *
 */
package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.EmployeeGenderRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.HashMap;
import java.util.Map;

public class EmployeeGenderMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static final Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        TOLERANCES.put(EmployeeGenderRule.MUST_NOT_BE_MALE, Tolerance.DNA);

        PAPER_TOLERANCES.put(EmployeeGenderRule.MISSING, Tolerance.DNA);
        PAPER_TOLERANCES.put(EmployeeGenderRule.MUST_NOT_BE_MALE, Tolerance.DNA);

    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][]{{EmployeeGenderRule.MISSING, "7525", "BR16.missing"},
                {DocumentError.VALUE, "5012", "BR16.value"}, {DocumentError.BLANK, "5016", "generic.5016"},
                {EmployeeGenderRule.MUST_NOT_BE_MALE, "7120", "BR16.4"}};
    }

    @Override
    protected String getLocator(final TaxYear year, String subCode) {
        return "P14 Employee's gender";
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    public String[] getRuleNames() {
        return new String[]{"EmployeeGenderRule"};
    }
}
