/**
 * $Id: $
 */
package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.EmployeeSurnameRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;

/**
 * @author Doug Clinton
 * 
 */
public class EmployeeSurnameMapper extends AbstractPAYEErrorMapper {

    private static Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    /**
     * Tolerances are the same for all years.
     */
    static {
        PAPER_TOLERANCES.put(EmployeeSurnameRule.FIRSTCHAR, Tolerance.DNA);
        PAPER_TOLERANCES.put(EmployeeSurnameRule.MANDATORY, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { EmployeeSurnameRule.FIRSTCHAR, "7590", "BR18.1" },
                { EmployeeSurnameRule.MANDATORY, "6010", "generic.6010" },
                { EmployeeSurnameRule.BLANK, "5016", "generic.5016" }, { EmployeeSurnameRule.FORMAT, "5012", "BR18.2" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Surname";
    }

    public String[] getRuleNames() {
        return new String[] { "EmployeeSurnameRule" };
    }
}
