/**
 * 
 */
package paye.eoy.output.mapper.p14;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractP14RequiredIfAnsweredYesRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;

public class EmployeesOutOfUKMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(AbstractP14RequiredIfAnsweredYesRule.IS_INC_NO_P14, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { AbstractP14RequiredIfAnsweredYesRule.HAS_INC_INVALID_ANS, "5012", "BR105.1" },
                { AbstractP14RequiredIfAnsweredYesRule.IS_INC_NO_P14, "7250", "BR105.2" },
                { AbstractP14RequiredIfAnsweredYesRule.BLANK_INC_YES_ANS, "7250", "BR104.2" },
                { AbstractP14RequiredIfAnsweredYesRule.HAS_INC_NO_ANS, "7250", "BR104.?" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Q4 part 2 - Employees out of UK";
    }

    public String[] getRuleNames() {
        return new String[] { "EmployeesOutOfUKRule" };
    }

}
