package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.eoy.bizrules.p14.payandtax.FinalTaxCodeRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class FinalTaxCodeMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[]{"FinalTaxCodeRule"};

    private static final String[][] ERROR_MAP_DATA = new String[][]{
            {FinalTaxCodeRule.NO_CODE, "7545", "BR43.2"},
            {FinalTaxCodeRule.BAD_W1M1IND, "5012", "BR44.1"},
            {FinalTaxCodeRule.BAD_TAX_REGIME, "6010", "BR46.1"},
            {FinalTaxCodeRule.SVR_PRESENT, "6010", "BR46.1/BR46.2"},
            {DocumentError.FORMAT, "5012", "BR43.1"},
            {DocumentError.BLANK, "6010", "BR43.2"}};

    private static final Map<String, String> LOCATORS = new HashMap<String, String>();

    static {
        LOCATORS.put(FinalTaxCodeRule.NO_CODE, "P14 Final tax code");
        LOCATORS.put(DocumentError.FORMAT, "P14 Final tax code");
        LOCATORS.put(FinalTaxCodeRule.BAD_W1M1IND, "P14 Week 1 Month 1 Indicator");
        LOCATORS.put(FinalTaxCodeRule.BAD_TAX_REGIME, "P14 Tax Regime");
        LOCATORS.put(FinalTaxCodeRule.SVR_PRESENT, "SVR");
        LOCATORS.put(DocumentError.MAXVALUE, "SVR");
        LOCATORS.put(DocumentError.MINVALUE, "SVR");
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATORS.get(subCode);
    }
}
