package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.nic.NICategoryCountRule;
import paye.eoy.bizrules.p14.nic.NICategoryRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Jay Mistry
 */
public class NICategoryMapper extends AbstractPAYEErrorMapper {

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        throw new UnsupportedOperationException("should be overriding getErrorMapData(SubmissionChannel) instead!");
    }

    protected String[][] getNonPaperErrorMapData() {
        final String[][] baseMapData = {{NICategoryCountRule.NO_NICS, "6010", "BR25.1"},
                {NICategoryCountRule.TOO_MANY, "6010", "BR25.1"}, {NICategoryRule.BAD_TABLE_CODE, "5012", "BR25.2"},
                {NICategoryRule.TOO_SHORT, "5016", "BR25.2"}, {NICategoryRule.TOO_LONG, "5012", "BR25.2"}};

        return baseMapData;
    }

    protected String[][] getPaperErrorMapData() {
        final String[][] baseMapData = {{NICategoryCountRule.NO_NICS, "6010", "BR25.1paper"},
                {NICategoryCountRule.TOO_MANY, "6010", "BR25.1paper"},
                {NICategoryRule.BAD_TABLE_CODE, "5012", "BR25.1paper"},
                {NICategoryRule.TOO_SHORT, "5016", "BR25.1paper"},
                {NICategoryRule.TOO_LONG, "5012", "BR25.1paper"}};

        return baseMapData;
    }

    @Override
    /**
     * In the paper channel, rules 25.1 and 25.2 have been merged into a single check and response so we need
     * to distinguish the response by channel.
     */
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear year) {
        switch (channel) {
            case Paper:
                return getPaperErrorMapData();
            default:
                return getNonPaperErrorMapData();
        }
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        return Collections.emptyMap();
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 NI category";
    }

    public String[] getRuleNames() {
        return new String[]{"NICategoryRule"};
    }

}
