package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.nino.AbstractNINORule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NinoErrorMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = {AbstractNINORule.NINO_RULE};

    private static final String[][] ERROR_MAP_DATA = {{AbstractNINORule.LENGTH, "5012", "BR14.format"},
            {DocumentError.FORMAT, "5012", "BR14.format"}, {AbstractNINORule.PAPER_FORMAT, "5012", "BR14.paperformat"},
            {DocumentError.BLANK, "5016", "generic.5016"}, {AbstractNINORule.SUFFIX, "5012", "BR14.format"},
            {AbstractNINORule.PREFIX, "7540", "BR14.prefix"}};


    private static final String LOCATOR = "P14 NINO";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        return Collections.emptyMap();
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }
}
