package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.p14.AbstractP14CountCountCheck;
import paye.eoy.bizrules.p14.P14CountCheckRuleOriginal;
import paye.eoy.bizrules.p14.P14CountFormatCheckRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class P14CountCheckMapper extends AbstractPAYEErrorMapper {

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Count";
    }

    private static final String[] RULE_NAMES = new String[]{"P14CountCheckRule"};


    private static final String[][] ERROR_MAP_DATA = new String[][]{
            {AbstractP14CountCountCheck.BAD_COUNT, "7530", "BR58.1",},
            {P14CountCheckRuleOriginal.SUPPLIED_COUNT_ZERO, "7585", "BR58.2",},
            {P14CountFormatCheckRule.BAD_FORMAT, "7530", "BR58.1_1",}, {DocumentError.FORMAT, "5012", "BR58.1_2",},
            {DocumentError.BLANK, "5016", "generic.5016",},
            {AbstractP14CountCountCheck.MISSING, "6010", "generic.6010"}};


    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }
}
