
package paye.eoy.output.mapper.p14;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class P14CountryMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    /**
     * These tolerances only from tax year 0607 onwards
     */
    static {
        TOLERANCES.put(DocumentError.FORMAT, Tolerance.DNA);
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "generic.5012" }, };
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel != SubmissionChannel.Paper) {
            return TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Country";
    }

    public String[] getRuleNames() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/Address/Country",
                "/IRenvelope/EndOfYearReturn/P14Amended/Address/Country" };
    }

}
