package paye.eoy.output.mapper.p14;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class P14DeclarationMapper extends AbstractPAYEErrorMapper {
    public static final String P14_DECLARATION_LOCATION = "P14 Declaration";

    private static final String[] RULE_NAMES = new String[] { "P14DeclarationRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { DocumentError.VALUE, "5012", "BR110.1" }, { DocumentError.FORMAT, "5012", "BR110.1" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" } };

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return P14_DECLARATION_LOCATION;
    }

}
