package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.p14.AbstractP14CountCountCheck;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class P14PartTotalsCountCheckMapperB extends AbstractP14PartTotalsCountCheckMapper {

    private static final String DOCUMENT_ERROR_LOCATOR = "P14 Count";

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String getLocator(final String subCode) {
        if (subCode.equals(DocumentError.FORMAT) || subCode.equals(DocumentError.BLANK) || subCode.equals(DocumentError.MANDATORY)
                || subCode.equals(AbstractP14CountCountCheck.MISSING)) {
            return DOCUMENT_ERROR_LOCATOR;
        }
        return super.getLocator(subCode);
    }
}
