/**
 * 
 */
package paye.eoy.output.mapper.p14;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class P14PostCodeMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "BR22.1" },
                { DocumentError.BLANK, "5016", "generic.5016" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Post Code";
    }

    public String[] getRuleNames() {
        return new String[] { "EmployeePostCodeRule", "/IRenvelope/EndOfYearReturn/P14/Address/PostCode",
                "/IRenvelope/EndOfYearReturn/P14Amended/Address/PostCode" };
    }

}
