package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class P14StLoanDeductionsThisEmpMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[]{"P14StLoanDeductionsThisEmpRule"};

    private static final String[][] ERROR_MAP_DATA = new String[][]{{DocumentError.FORMAT, "5012", "nonneg.amount"},
            {WholePoundsHelper.NOT_WHOLE_POUNDS, "5012", "whole.nonneg.amount"}, {DocumentError.MINVALUE, "5012", "BR42.2"},
            {DocumentError.MAXVALUE, "5012", "whole.nonneg.amount"}};

    private static final String LOCATOR = "P14 Student loan deductions in this employment";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData(final SubmissionChannel channel, final TaxYear taxYear) {
        return ERROR_MAP_DATA;

    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }

}
