/**
 * 
 */
package paye.eoy.output.mapper.p14;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class P14StatutoryAdoptionPayMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR34.2" },
                { DocumentError.MAXVALUE, "5012", "nonneg.amount" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Statutory Adoption Pay (SAP)";
    }

    public String[] getRuleNames() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/SAP", "/IRenvelope/EndOfYearReturn/P14Amended/SAP" };
    }

}
