/**
 *
 */
package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.SMPRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Jay Mistry
 */
public class P14StatutoryMaternityPayMapper extends AbstractPAYEErrorMapper {

    private static final Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    private static final String[][] ERROR_MAP_DATA = new String[][]{{SMPRule.MUST_BE_ZERO_FOR_MALES, "7490", "BR32.3"},
            {SMPRule.GENDER_REQUIRED, "7525", "BR16.3"}, {DocumentError.FORMAT, "5012", "nonneg.amount"},
            {DocumentError.MINVALUE, "5012", "BR122.2"}, {DocumentError.MAXVALUE, "5012", "nonneg.amount"}};

    /**
     * Tolerances are the same for all years.
     */
    static {
        PAPER_TOLERANCES.put(SMPRule.MUST_BE_ZERO_FOR_MALES, Tolerance.DNA);
        PAPER_TOLERANCES.put(SMPRule.GENDER_REQUIRED, Tolerance.DNA);

        TOLERANCES.put(SMPRule.MUST_BE_ZERO_FOR_MALES, Tolerance.DNA);
        TOLERANCES.put(SMPRule.GENDER_REQUIRED, Tolerance.DNA);

    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        if (subCode.equals(SMPRule.GENDER_REQUIRED)) {
            return "P14 Employee's gender";
        } else {
            return "P14 Statutory Maternity Pay (SMP)";
        }
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    public String[] getRuleNames() {
        return new String[]{"SMPRule"};
    }

}
