
package paye.eoy.output.mapper.p14;

import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 */
public class P14StatutorySickPayMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
        return new String[][]{{DocumentError.FORMAT, "5012", "nonneg.amount"},
                {DocumentError.MINVALUE, "5012", "BR31.2"}, {DocumentError.MAXVALUE, "5012", "nonneg.amount"}};
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Statutory Sick Pay (SSP)";
    }

    public String[] getRuleNames() {
        return new String[]{"/IRenvelope/EndOfYearReturn/P14/SSP", "/IRenvelope/EndOfYearReturn/P14Amended/SSP"};
    }

}
