/**
 * 
 */
package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.payandtax.TaxInPrevEmpRuleOriginal;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class P14TaxDeductedinPreviousEmploymentMapper extends AbstractPAYEErrorMapper {

    private static final String LOCATOR = "P14 Tax deducted in previous employment(s)";

    private static Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    /**
     * Tolerances are the same for all years.
     */
    static {
        PAPER_TOLERANCES.put(TaxInPrevEmpRuleOriginal.TAX_GT_TAXABLE_PAY, Tolerance.DNA);
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR38.2" },
                { DocumentError.MAXVALUE, "5012", "nonneg.amount" },
                { TaxInPrevEmpRuleOriginal.TAX_GT_TAXABLE_PAY, "7190", "BR38.3" },
                { TaxInPrevEmpRuleOriginal.TAXABLE_PAY_LT_TAX, "5012", "nonneg.amount" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        if (TaxInPrevEmpRuleOriginal.TAXABLE_PAY_LT_TAX.equals(subCode)) {
            return P14PayinPreviousEmploymentMapper.LOCATOR;
        } else {
            return LOCATOR;
        }
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    public String[] getRuleNames() {
        return new String[] { "TaxInPrevEmpRule", "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/PrevEmp/Tax" };
    }

}
