/**
 * 
 */
package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.p14.payandtax.TaxInThisEmpRuleOriginal;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class P14TaxDeductedinThisEmploymentMapperB extends AbstractP14TaxDeductedinThisEmploymentMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { TaxInThisEmpRuleOriginal.GT_PAY_THIS_EMP, "7200", "BR40.3" },
                { TaxInThisEmpRuleOriginal.MUST_BE_LT_TAX_PREV_EMP, "7200", "BR40.4" }, { DocumentError.FORMAT, "5012", "amount" },
                { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" }, };
    }

    public String[] getRuleNames() {
        return new String[] { "TaxInThisEmpRule", "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Tax",
                "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/Tax" };
    }

}
