package paye.eoy.output.mapper.p14;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class P14WidowsAndOrphansMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/WidOrph",
            "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/WidOrph" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { DocumentError.MAXVALUE, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR41.2" } };

    private static final String LOCATOR = "P14 Widows and Orphans";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
