/**
 * 
 */
package paye.eoy.output.mapper.p14;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class P14WorksNumberMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "BR17" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "P14 Works number";
    }

    public String[] getRuleNames() {
        return new String[] { "WorksNumberRule", "/IRenvelope/EndOfYearReturn/P14/WkNo",
                "/IRenvelope/EndOfYearReturn/P14Amended/WkNo" };
    }

}
