package paye.eoy.output.mapper.p14;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class PaymentInWk53Mapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] {
            "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/Week53Indicator",
            "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Week53Indicator" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.VALUE, "5012", "BR47.1" },
            { DocumentError.BLANK, "5016", "generic.5016" }, { DocumentError.FORMAT, "5012", "BR47.1" } };

    private static final String LOCATOR = "P14 Payment in week 53 indicator";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
