/**
 * $Id: $
 */
package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * @author Doug Clinton
 * 
 */
public class PrincipalSurnameMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static Map<String, Tolerance> tolerances = new HashMap<String, Tolerance>();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "generic.5012" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Principal Surname";
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        return tolerances;
    }

    public String[] getRuleNames() {
        return new String[] { "PrincipalSurnameRule" };
    }
}
