/**
 * $Id: $
 */
package paye.eoy.output.mapper.p14;

import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Doug Clinton
 * 
 */
public class TaxablePayMapperB extends AbstractTaxablePayMapper {
    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR39.2" },
                { DocumentError.MAXVALUE, "5012", "nonneg.amount" } };
    }
}
