package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Doug Clinton
 * @since 15/17/2010
 * 
 */
public class TotalASPPMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" },
                { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.BLANK, "5016", "generic.5016" },
                { AbstractSimpleTotalRule.BAD_TOTAL, "7285", "TotalASPP.2" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Total of ASPP";
    }

    public String[] getRuleNames() {
        return new String[] { "TotalASPPRule" };
    }

}
