package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.p14.parttotals.AbstractTotalContributions;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * 
 * @author Jay Mistry
 * 
 */
public class TotalContributionsMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "amount" },
                { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" },
                { AbstractTotalContributions.BAD_TOTAL, "7160", "BR49.2" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Total of employee's and employer's contributions";
    }

    public String[] getRuleNames() {
        return new String[] { "TotalContributionsRule" };
    }

}
