package paye.eoy.output.mapper.p14;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p14.nic.AbstractTotalContributionsPayableRule;
import paye.eoy.bizrules.p14.nic.TotalContributionsPayableRuleOriginal;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class TotalContributionsPayableMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "TotalContributionsPayableRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { AbstractTotalContributionsPayableRule.X_BOTH_LT_ZERO, "7170", "BR29.3" },
            { TotalContributionsPayableRuleOriginal.BOTH_LT_EMP, "7170", "BR29.4" },
            { TotalContributionsPayableRuleOriginal.BOTH_LT_ZERO, "7170", "BR29.5" },
            { DocumentError.FORMAT, "5012", "nonneg.amount.format" }, { DocumentError.MAXVALUE, "5012", "nonneg.amount.format" } };

    private static final String LOCATOR = "P14 Total of employee's and employer's contributions payable";

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();
    static {
        PAPER_TOLERANCES.put(AbstractTotalContributionsPayableRule.X_BOTH_LT_ZERO, Tolerance.DNA);
        PAPER_TOLERANCES.put(TotalContributionsPayableRuleOriginal.BOTH_LT_EMP, Tolerance.DNA);
        PAPER_TOLERANCES.put(TotalContributionsPayableRuleOriginal.BOTH_LT_ZERO, Tolerance.DNA);
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }
}
