/**
 * 
 */
package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class TotalSSPMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "amount" }, { DocumentError.MINVALUE, "5012", "BR28.2.2" },
                { DocumentError.MAXVALUE, "5012", "amount" }, { AbstractSimpleTotalRule.BAD_TOTAL, "7210", "BR51.2" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Total of SSP";
    }

    public String[] getRuleNames() {
        return new String[] { "TotalSSPRule" };
    }

}
