package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * 
 * @author Jay Mistry
 * 
 */
public class TotalTaxFromP14sMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { AbstractSimpleTotalRule.BAD_TOTAL, "7420", "BR114.value" },
                { DocumentError.FORMAT, "5012", "BR114.format" }, { DocumentError.MINVALUE, "5012", "BR114.format" },
                { DocumentError.MAXVALUE, "5012", "BR114.format" }, };
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Total tax from P14s";
    }

    public String[] getRuleNames() {
        return new String[] { "TotalTaxFromP14sRule", "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/P14Tax",
                "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/P14Tax" };
    }

}
