package paye.eoy.output.mapper.p14;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import xmldoc.DocumentError;

/**
 * 
 * @author Jay Mistry
 * 
 */
public class TotalTaxMapperA extends AbstractTotalTaxMapper {

    public String[] getRuleNames() {
        return new String[] { "TotalTaxInThisEmpRule" };
    }

    @Override
    protected String getLocator(final String subCode) {
        if (AbstractSimpleTotalRule.BAD_TOTAL.equals(subCode)) {
            return "Total of tax in this employment";
        } else {
            return "Total Tax";
        }
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "amount" }, { DocumentError.MINVALUE, "5012", "amount" },
                { DocumentError.MAXVALUE, "5012", "amount" }, { AbstractSimpleTotalRule.BAD_TOTAL, "7180", "BR50.value" } };
    }

}
