/**
 * 
 */
package paye.eoy.output.mapper.p14;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractTotalTaxRule;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class TotalTaxMapperB extends AbstractTotalTaxMapper {

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "amount" }, { DocumentError.MINVALUE, "5012", "amount" },
                { DocumentError.MAXVALUE, "5012", "amount" }, { AbstractTotalTaxRule.BAD_TOTAL, "7440", "BR117.2" } };
    }

    protected static final Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    protected static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    /**
     * Tolerances are the same for all years.
     */
    static {
        PAPER_TOLERANCES.put(AbstractTotalTaxRule.BAD_TOTAL, Tolerance.DNA);
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Total Tax";
    }

    public String[] getRuleNames() {
        return new String[] { "TotalTaxRule", "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TotalTax",
                "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TotalTax" };
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }
}
